'From Squeak4.3 of 22 December 2011 [latest update: #11860] on 23 February 2012 at 1:38:02 pm'!
Object subclass: #BaseballScore
	instanceVariableNames: 'first second third home runner numStrikes numOuts numBalls numRuns currentTeam currentInning teamName score pitcher'
	classVariableNames: ''
	poolDictionaries: 'PitchResult'
	category: 'My Stuff'!

!BaseballScore methodsFor: 'private' stamp: 'DY 2/5/2004 20:51'!
advanceRunners: numBases 
	numBases > 0
		ifTrue: [(runner at: third)
				ifTrue: [numRuns _ numRuns + 1.
					runner at: third put: false].
			(runner at: second)
				ifTrue: [numBases > 1
						ifTrue: [numRuns _ numRuns + 1]
						ifFalse: [runner at: third put: true].
					runner at: second put: false].
			(runner at: first)
				ifTrue: [numBases > 2
						ifTrue: [numRuns _ numRuns + 1]
						ifFalse: [numBases = 2
								ifTrue: [runner at: third put: true]
								ifFalse: [runner at: second put: true]].
					runner at: first put: false]]! !

!BaseballScore methodsFor: 'private' stamp: 'DPY 2/23/2012 13:26'!
initialize
	"Initialize instance variables"
	first := 1.
	second := 2.
	third := 3.
	home := 4.
	runner := Array new: 4.
	runner atAllPut: false.
	currentInning := 1.
	currentTeam := 1.
	score := Array new: 2. 
	1 to: 2 do: [:i | score at: i put: (Array new: 30). (score at: i) atAllPut: 0].
	teamName := Array new: 2.
	teamName atAllPut: ''.
	numStrikes := numOuts := numBalls := numRuns := 0.
	pitcher := Array new: 2.
	
	! !

!BaseballScore methodsFor: 'private' stamp: 'DPY 2/23/2012 13:37'!
sideout
	(score at: currentTeam) at: currentInning put: numRuns.
	currentTeam = 2 ifTrue: [
		currentInning := currentInning + 1].
	currentTeam := 3 - currentTeam.
	numStrikes := numBalls := numOuts := numRuns := 0.
	runner atAllPut: false.! !


!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 22:09'!
pitch
	(pitcher at: currentTeam) throw.
	self putPitch: (pitcher at: currentTeam) pitch.
	! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/6/2004 09:03'!
playInning
	currentTeam = 1 & self gameOver not ifTrue: [
		[ currentTeam = 1 ] whileTrue: [ self pitch ]
	].
	self gameOver not ifTrue: [
		[ currentTeam = 2 & self gameOver not ] whileTrue: [ self pitch ]
	]	! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 19:13'!
putBall
	numBalls := numBalls + 1.
	numBalls = 4 ifTrue: [ self putHitBatter ].! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 20:55'!
putDouble
	self advanceRunners: 2.
	runner at: second put: true.
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 20:59'!
putFoul
	numStrikes < 2 ifTrue: [ self putStrike ]! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 19:05'!
putHitBatter
	(runner at: first) ifFalse: [runner at: first put: true]
	ifTrue: [
		(runner at: second) ifFalse: [
			runner at: second put: true
		]
		ifTrue: [
			(runner at: third) ifFalse: [
				runner at: third put: true
			]
			ifTrue: [
				numRuns := numRuns + 1.
			]
		]
	].
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 20:57'!
putHomer
	self advanceRunners: 4.
	numRuns := numRuns + 1.
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 19:07'!
putOut
	numOuts := numOuts + 1.
	(numOuts < 3) ifFalse: [ self sideout ].
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 22:03'!
putPitch: anInteger
	anInteger caseOf: {
		[Hitbatter] -> [ self putHitBatter ].
		[Strike] -> [ self putStrike ].
		[Ball] -> [ self putBall ].
		[Single] -> [ self putSingle ].
		[Double] -> [ self putDouble ].
		[Triple] -> [ self putTriple ].
		[Homer] -> [ self putHomer ].
		[Out] -> [ self putOut ].
		[Foul] -> [ self putFoul ].
	}! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 19:15'!
putSingle
	self advanceRunners: 1.
	runner at: first put: true.
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 20:59'!
putStrike
	numStrikes := numStrikes + 1.
	numStrikes = 3 ifTrue: [ self putOut ]! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 20:56'!
putTriple
	self advanceRunners: 3.
	runner at: third put: true.
	numBalls := numStrikes := 0.! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 22:07'!
setPitcherForTeam: i to: aPitcher
	pitcher at: i put: aPitcher
	! !

!BaseballScore methodsFor: 'modifying' stamp: 'DY 2/5/2004 18:59'!
setTeamName: index to: name
	^teamName at: index put: name! !


!BaseballScore methodsFor: 'display' stamp: 'DPY 2/23/2012 13:30'!
displayOnTranscript
	| tab |
	tab := 9 asCharacter asString.
	1 to: 2 do: [ :i |
		Transcript show: (teamName at: i), tab.
		1 to: currentInning-1 do: [ :j |
			Transcript show: ((score at: i) at: j) printString, tab.
		].
		self gameOver ifTrue: [ 
			currentTeam = 2 ifTrue: "A winning go-ahead run was scored in the bottom half of the inning,
									 or team 1 failed to go ahead in the top half of the ninth inning"
				[  | scoreInInning |
					scoreInInning := (score at: i) at: currentInning.
					i = 2 ifTrue:  [ scoreInInning := scoreInInning + numRuns ].
					Transcript show: scoreInInning printString, tab. 
				]
		].
		Transcript show: tab, tab, (self scoreForTeam: i) printString, Character cr asString
	]! !


!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 15:37'!
balls
	^numBalls! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/6/2004 09:09'!
currentInning
	^currentInning! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 21:23'!
gameOver
	currentInning < 9 ifTrue: [ ^false ].
	currentInning = 9 ifTrue: [
		currentTeam = 1 ifTrue: [ ^false ].
		^ (self scoreForTeam: 1) < (self scoreForTeam: 2).
	].
	currentTeam = 1 ifTrue: [
		^ (self scoreForTeam: 1 throughInning: currentInning-1) ~~ (self scoreForTeam: 2 throughInning: currentInning-1) 
	].
	^ (self scoreForTeam: 1) < (self scoreForTeam: 2)! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 15:36'!
hasRunner: base

	^runner at: base.! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 18:58'!
outs
	^numOuts! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 21:01'!
scoreForTeam: team
	^self scoreForTeam: team throughInning: currentInning! !

!BaseballScore methodsFor: 'accessing' stamp: 'DPY 2/23/2012 13:30'!
scoreForTeam: team inInning: inning
	| teamScore |
	teamScore := -1.
	(team < 1) not & (team > 2) not & (inning > 0) & (inning > currentInning) not ifTrue: [
		teamScore := (score at: team) at: inning.
		inning = currentInning & (team = currentTeam) ifTrue: [
			teamScore := teamScore + numRuns
		]
	].
	^ teamScore ! !

!BaseballScore methodsFor: 'accessing' stamp: 'DPY 2/23/2012 13:31'!
scoreForTeam: team throughInning: inning
	| totalScore |
	(team < 1) not & (team > 2) not & (inning > currentInning) not ifTrue: [
		totalScore := 0.
		1 to: inning do: [ :j |
			totalScore := totalScore + ((score at: team) at: j)
		].
		inning = currentInning & (team = currentTeam) ifTrue: [
			totalScore := totalScore + numRuns
		].
		^ totalScore
	].
	^ -1! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 20:51'!
sideAtBat
	^currentTeam! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 15:37'!
strikes
	^numStrikes! !

!BaseballScore methodsFor: 'accessing' stamp: 'DY 2/5/2004 18:57'!
teamName: index
	^teamName at: index! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BaseballScore class
	instanceVariableNames: ''!

!BaseballScore class methodsFor: 'as yet unclassified' stamp: 'DY 2/5/2004 15:33'!
new
	^ super new initialize! !
